# Surveys, Taxonomies and more
## Table of Contents
- Surveys, Taxonomies and more
	 - [Surveys](#surveys)
		 - [Surveys on Attacks](#surveys-on-attacks)
		 - [Surveys on Risks](#surveys-on-risks)
		 - [Surveys on Defenses](#surveys-on-defenses)
	 - [Taxonomies](#taxonomies)
	 - [Positions](#positions)
	 - [Phenomenon](#phenomenon)
		 - [Mechanistic Interpretability](#mechanistic-interpretability)
## Surveys
- **A Survey of Backdoor Attacks and Defenses on Large Language Models: Implications for Security Measures** \[[Paper](https://arxiv.org/abs/2406.06852
   )\] <br />
Shuai Zhao,  Meihuizi Jia,  Zhongliang Guo,  Leilei Gan,  Jie Fu,  Yichao Feng,  Fengjun Pan,  Luu Anh Tuan (2024)<br />
- **Risk Taxonomy,Mitigation,and Assessment Benchmarks of Large Language Model Systems** \[[Paper](https://arxiv.org/abs/2401.05778)\] <br />
Tianyu Cui,  Yanling Wang,  Chuanpu Fu,  Yong Xiao,  Sijia Li,  Xinhao Deng,  Yunpeng Liu,  Qinglin Zhang,  Ziyi Qiu,  Peiyang Li,  Zhixing Tan,  Junwu Xiong,  Xinyu Kong,  Zujie Wen,  Ke Xu,  Qi Li (2024)<br />
- **Current state of LLM Risks and AI Guardrails** \[[Paper](https://arxiv.org/abs/2406.12934
   )\] <br />
Suriya Ganesh Ayyamperumal,  Limin Ge (2024)<br />
- **Unique Security and Privacy Threats of Large Language Model: A Comprehensive Survey** \[[Paper](https://arxiv.org/abs/2406.07973
   )\] <br />
Shang Wang,  Tianqing Zhu,  Bo Liu,  Ming Ding,  Xu Guo,  Dayong Ye,  Wanlei Zhou,  Philip S. Yu (2024)<br />
- **TrustLLM: Trustworthiness in Large Language Models** \[[Paper](https://arxiv.org/abs/2401.05561)\] <br />
Lichao Sun,  Yue Huang,  Haoran Wang,  Siyuan Wu,  Qihui Zhang,  Yuan Li,  Chujie Gao,  Yixin Huang,  Wenhan Lyu,  Yixuan Zhang,  Xiner Li,  Zhengliang Liu,  Yixin Liu,  Yijue Wang,  Zhikun Zhang,  Bertie Vidgen,  Bhavya Kailkhura,  Caiming Xiong,  Chaowei Xiao,  Chunyuan Li,  Eric Xing,  Furong Huang,  Hao Liu,  Heng Ji,  Hongyi Wang,  Huan Zhang,  Huaxiu Yao,  Manolis Kellis,  Marinka Zitnik,  Meng Jiang,  Mohit Bansal,  James Zou,  Jian Pei,  Jian Liu,  Jianfeng Gao,  Jiawei Han,  Jieyu Zhao,  Jiliang Tang,  Jindong Wang,  Joaquin Vanschoren,  John Mitchell,  Kai Shu,  Kaidi Xu,  Kai-Wei Chang,  Lifang He,  Lifu Huang,  Michael Backes,  Neil Zhenqiang Gong,  Philip S. Yu,  Pin-Yu Chen,  Quanquan Gu,  Ran Xu,  Rex Ying,  Shuiwang Ji,  Suman Jana,  Tianlong Chen,  Tianming Liu,  Tianyi Zhou,  William Wang,  Xiang Li,  Xiangliang Zhang,  Xiao Wang,  Xing Xie,  Xun Chen,  Xuyu Wang,  Yan Liu,  Yanfang Ye,  Yinzhi Cao,  Yong Chen,  Yue Zhao (2024)<br />
- **Threat Modelling and Risk Analysis for Large Language Model (LLM)-Powered Applications** \[[Paper](https://arxiv.org/abs/2406.11007
   )\] <br />
Stephen Burabari Tete (2024)<br />
- **PRISM: A Design Framework for Open-Source Foundation Model Safety** \[[Paper](https://arxiv.org/abs/2406.10415
   )\] <br />
Terrence Neumann,  Bryan Jones (2024)<br />
- **Personal LLM Agents: Insights and Survey about the Capability,Efficiency and Security** \[[Paper](https://arxiv.org/abs/2401.05459)\] <br />
Yuanchun Li,  Hao Wen,  Weijun Wang,  Xiangyu Li,  Yizhen Yuan,  Guohong Liu,  Jiacheng Liu,  Wenxing Xu,  Xiang Wang,  Yi Sun,  Rui Kong,  Yile Wang,  Hanfei Geng,  Jian Luan,  Xuefeng Jin,  Zilong Ye,  Guanjing Xiong,  Fan Zhang,  Xiang Li,  Mengwei Xu,  Zhijun Li,  Peng Li,  Yang Liu,  Ya-Qin Zhang,  Yunxin Liu (2024)<br />
- **Competition Report: Finding Universal Jailbreak Backdoors in Aligned LLMs** \[[Paper](https://arxiv.org/abs/2404.14461
   )\] <br />
Javier Rando,  Francesco Croce,  Kryštof Mitka,  Stepan Shabalin,  Maksym Andriushchenko,  Nicolas Flammarion,  Florian Tramèr (2024)<br />
- **Security and Privacy Challenges of Large Language Models: A Survey** \[[Paper](https://arxiv.org/abs/2402.00888)\] <br />
Badhan Chandra Das,  M. Hadi Amini,  Yanzhao Wu (2024)<br />
- **Foundational Challenges in Assuring Alignment and Safety of Large Language Models** \[[Paper](https://arxiv.org/abs/2404.09932)\] <br />
Usman Anwar,  Abulhair Saparov,  Javier Rando,  Daniel Paleka,  Miles Turpin,  Peter Hase,  Ekdeep Singh Lubana,  Erik Jenner,  Stephen Casper,  Oliver Sourbut,  Benjamin L. Edelman,  Zhaowei Zhang,  Mario Günther,  Anton Korinek,  Jose Hernandez-Orallo,  Lewis Hammond,  Eric Bigelow,  Alexander Pan,  Lauro Langosco,  Tomasz Korbak,  Heidi Zhang,  Ruiqi Zhong,  Seán Ó hÉigeartaigh,  Gabriel Recchia,  Giulio Corsi,  Alan Chan,  Markus Anderljung,  Lilian Edwards,  Yoshua Bengio,  Danqi Chen,  Samuel Albanie,  Tegan Maharaj,  Jakob Foerster,  Florian Tramer,  He He,  Atoosa Kasirzadeh,  Yejin Choi,  David Krueger (2024)<br />
- **Online Safety Analysis for LLMs: a Benchmark, an Assessment, and a Path Forward** \[[Paper](https://arxiv.org/abs/2404.08517
   )\] <br />
Xuan Xie,  Jiayang Song,  Zhehua Zhou,  Yuheng Huang,  Da Song,  Lei Ma (2024)<br />
- **Human-AI Safety: A Descendant of Generative AI and Control Systems Safety** \[[Paper](https://arxiv.org/abs/2405.09794
   )\] <br />
Andrea Bajcsy,  Jaime F. Fisac (2024)<br />
### Surveys on Attacks
- **Robust Testing of AI Language Model Resiliency with Novel Adversarial Prompts** \[[Paper](https://www.mdpi.com/2079-9292/13/5/842)\] <br />
Brendan Hannon,  Yulia Kumar,  Dejaun Gayle,  J. Jenny Li,  Patricia Morreale (2024)<br />
- **Exploring Vulnerabilities and Protections in Large Language Models: A Survey** \[[Paper](https://arxiv.org/abs/2406.00240
   )\] <br />
Frank Weizhen Liu,  Chenhui Hu (2024)<br />
- **Breaking Down the Defenses: A Comparative Survey of Attacks on Large Language Models** \[[Paper](https://arxiv.org/abs/2403.04786)\] <br />
Arijit Ghosh Chowdhury,  Md Mofijul Islam,  Vaibhav Kumar,  Faysal Hossain Shezan,  Vaibhav Kumar,  Vinija Jain,  Aman Chadha (2024)<br />
- **Don't Listen To Me: Understanding and Exploring Jailbreak Prompts of Large Language Models** \[[Paper](https://arxiv.org/abs/2403.16432)\] <br />
Yue Xu,  Wenjie Wang (2024)<br />
- **Comprehensive Assessment of Jailbreak Attacks Against LLMs** \[[Paper](https://arxiv.org/abs/2402.05668)\] <br />
Junjie Chu,  Yugeng Liu,  Ziqing Yang,  Xinyue Shen,  Michael Backes,  Yang Zhang (2024)<br />
- **LLM Jailbreak Attack versus Defense Techniques -- A Comprehensive Study** \[[Paper](https://arxiv.org/abs/2402.13457)\] <br />
Zihao Xu,  Yi Liu,  Gelei Deng,  Yuekang Li,  Stjepan Picek (2024)<br />
- **An Early Categorization of Prompt Injection Attacks on Large Language Models** \[[Paper](https://arxiv.org/abs/2402.00898)\] <br />
Sippo Rossi,  Alisia Marianne Michel,  Raghava Rao Mukkamala,  Jason Bennett Thatcher (2024)<br />
- **A Comprehensive Survey of Attack Techniques,Implementation,and Mitigation Strategies in Large Language Models** \[[Paper](https://arxiv.org/abs/2312.10982)\] <br />
Aysan Esmradi,  Daniel Wankit Yip,  Chun Fai Chan (2023)<br />
- **Summon a Demon and Bind it: A Grounded Theory of LLM Red Teaming in the Wild** \[[Paper](https://arxiv.org/abs/2311.06237)\] <br />
Nanna Inie,  Jonathan Stray,  Leon Derczynski (2023)<br />
- **Beyond Boundaries: A Comprehensive Survey of Transferable Attacks on AI Systems** \[[Paper](https://arxiv.org/abs/2311.11796)\] <br />
Guangjing Wang,  Ce Zhou,  Yuanda Wang,  Bocheng Chen,  Hanqing Guo,  Qiben Yan (2023)<br />
- **Beyond Boundaries: A Comprehensive Survey of Transferable Attacks on AI Systems** \[[Paper](https://arxiv.org/abs/2311.11796)\] <br />
Guangjing Wang,  Ce Zhou,  Yuanda Wang,  Bocheng Chen,  Hanqing Guo,  Qiben Yan (2023)<br />
- **Survey of Vulnerabilities in Large Language Models Revealed by Adversarial Attacks** \[[Paper](https://arxiv.org/abs/2310.10844)\] <br />
Erfan Shayegani,  Md Abdullah Al Mamun,  Yu Fu,  Pedram Zaree,  Yue Dong,  Nael Abu-Ghazaleh (2023)<br />
- **Adversarial Attacks and Defenses in Large Language Models: Old and New Threats** \[[Paper](https://arxiv.org/abs/2310.19737)\] <br />
Leo Schwinn,  David Dobre,  Stephan Günnemann,  Gauthier Gidel (2023)<br />
- **Ignore This Title and HackAPrompt: Exposing Systemic Vulnerabilities of LLMs through a Global Scale Prompt Hacking Competition** \[[Paper](https://arxiv.org/abs/2311.16119)\] <br />
Sander Schulhoff,  Jeremy Pinto,  Anaum Khan,  Louis-François Bouchard,  Chenglei Si,  Svetlina Anati,  Valen Tagliabue,  Anson Liu Kost,  Christopher Carnahan,  Jordan Boyd-Graber (2023)<br />
- **"Do Anything Now": Characterizing and Evaluating In-The-Wild Jailbreak Prompts on Large Language Models** \[[Paper](https://arxiv.org/abs/2308.03825)\] <br />
Xinyue Shen,  Zeyuan Chen,  Michael Backes,  Yun Shen,  Yang Zhang (2023)<br />
- **Tricking LLMs into Disobedience: Formalizing,Analyzing,and Detecting Jailbreaks** \[[Paper](https://arxiv.org/abs/2305.14965)\] <br />
Abhinav Rao,  Sachin Vashistha,  Atharva Naik,  Somak Aditya,  Monojit Choudhury (2023)<br />
### Surveys on Risks
- **Securing Large Language Models: Threats,Vulnerabilities and Responsible Practices** \[[Paper](https://arxiv.org/abs/2403.12503)\] <br />
Sara Abdali,  Richard Anarfi,  CJ Barberan,  Jia He (2024)<br />
- **Mapping LLM Security Landscapes: A Comprehensive Stakeholder Risk Assessment Proposal** \[[Paper](https://arxiv.org/abs/2403.13309)\] <br />
Rahul Pankajakshan,  Sumitra Biswal,  Yuvaraj Govindarajulu,  Gilad Gressel (2024)<br />
- **Identifying and Mitigating Vulnerabilities in LLM-Integrated Applications** \[[Paper](https://arxiv.org/abs/2311.16153)\] <br />
Fengqing Jiang,  Zhangchen Xu,  Luyao Niu,  Boxin Wang,  Jinyuan Jia,  Bo Li,  Radha Poovendran (2023)<br />
- **Privacy in Large Language Models: Attacks,Defenses and Future Directions** \[[Paper](https://arxiv.org/abs/2310.10383)\] <br />
Haoran Li,  Yulin Chen,  Jinglong Luo,  Yan Kang,  Xiaojin Zhang,  Qi Hu,  Chunkit Chan,  Yangqiu Song (2023)<br />
- **Use of LLMs for Illicit Purposes: Threats,Prevention Measures,and Vulnerabilities** \[[Paper](https://arxiv.org/abs/2308.12833)\] <br />
Maximilian Mozes,  Xuanli He,  Bennett Kleinberg,  Lewis D. Griffin (2023)<br />
- **From ChatGPT to ThreatGPT: Impact of Generative AI in Cybersecurity and Privacy** \[[Paper](https://arxiv.org/abs/2307.00691)\] <br />
Maanak Gupta,  CharanKumar Akiri,  Kshitiz Aryal,  Eli Parker,  Lopamudra Praharaj (2023)<br />
- **Beyond the Safeguards: Exploring the Security Risks of ChatGPT** \[[Paper](https://arxiv.org/abs/2305.08005)\] <br />
Erik Derner,  Kristina Batistič (2023)<br />
- **Towards Safer Generative Language Models: A Survey on Safety Risks,Evaluations,and Improvements** \[[Paper](https://arxiv.org/abs/2302.0927)\] <br />
Jiawen Deng,  Jiale Cheng,  Hao Sun,  Zhexin Zhang,  Minlie Huang (2023)<br />
- **The power of generative AI in cybersecurity: Opportunities and challenges** \[[Paper](https://ace.ewapublishing.org/media/50a3b1ae25cc43f4b2a62ca50409a1e2.marked.pdf)\] <br />
Shibo Wen (2024)<br />
### Surveys on Defenses
- **An AI System Evaluation Framework for Advancing AI Safety: Terminology, Taxonomy, Lifecycle Mapping** \[[Paper](https://arxiv.org/abs/2404.05388
   )\] <br />
Boming Xia,  Qinghua Lu,  Liming Zhu,  Zhenchang Xing (2024)<br />
- **Safeguarding Large Language Models: A Survey** \[[Paper](https://arxiv.org/abs/2406.02622
   )\] <br />
Yi Dong,  Ronghui Mu,  Yanghao Zhang,  Siqi Sun,  Tianle Zhang,  Changshun Wu,  Gaojie Jin,  Yi Qi,  Jinwei Hu,  Jie Meng,  Saddek Bensalem,  Xiaowei Huang (2024)<br />
## Taxonomies
- **Coercing LLMs to do and reveal (almost) anything** \[[Paper](https://arxiv.org/abs/2402.1402)\] <br />
Jonas Geiping,  Alex Stein,  Manli Shu,  Khalid Saifullah,  Yuxin Wen,  Tom Goldstein (2024)<br />
- **A Security Risk Taxonomy for Large Language Models** \[[Paper](https://arxiv.org/abs/2311.11415)\] <br />
Erik Derner,  Kristina Batistič,  Jan Zahálka,  Robert Babuška (2023)<br />
- **The History and Risks of Reinforcement Learning and Human Feedback** \[[Paper](https://arxiv.org/abs/2310.13595)\] <br />
Nathan Lambert,  Thomas Krendl Gilbert,  Tom Zick (2023)<br />
- **From Chatbots to PhishBots? -- Preventing Phishing scams created using ChatGPT,Google Bard and Claude** \[[Paper](https://arxiv.org/abs/2310.19181)\] <br />
Sayak Saha Roy,  Poojitha Thota,  Krishna Vamsi Naragam,  Shirin Nilizadeh (2023)<br />
- **AI Deception: A Survey of Examples,Risks,and Potential Solutions** \[[Paper](https://arxiv.org/abs/2308.14752)\] <br />
Peter S. Park,  Simon Goldstein,  Aidan O'Gara,  Michael Chen,  Dan Hendrycks (2023)<br />
- **Generating Phishing Attacks using ChatGPT** \[[Paper](https://arxiv.org/abs/2305.05133)\] <br />
Sayak Saha Roy,  Krishna Vamsi Naragam,  Shirin Nilizadeh (2023)<br />
- **Jailbreaking ChatGPT via Prompt Engineering: An Empirical Study** \[[Paper](https://arxiv.org/abs/2305.1386)\] <br />
Yi Liu,  Gelei Deng,  Zhengzi Xu,  Yuekang Li,  Yaowen Zheng,  Ying Zhang,  Lida Zhao,  Tianwei Zhang,  Kailong Wang,  Yang Liu (2023)<br />
- **Personalisation within bounds: A risk taxonomy and policy framework for the alignment of large language models with personalised feedback** \[[Paper](https://arxiv.org/abs/2303.05453)\] <br />
Hannah Rose Kirk,  Bertie Vidgen,  Paul Röttger,  Scott A. Hale (2023)<br />
## Positions
- **AI Safety: A Climb To Armageddon?** \[[Paper](https://arxiv.org/abs/2405.19832
   )\] <br />
Herman Cappelen,  Josh Dever,  John Hawthorne (2024)<br />
- **[WIP] Jailbreak Paradox: The Achilles' Heel of LLMs** \[[Paper](https://arxiv.org/abs/2406.12702
   )\] <br />
Abhinav Rao,  Monojit Choudhury,  Somak Aditya (2024)<br />
- **A Safe Harbor for AI Evaluation and Red Teaming** \[[Paper](https://arxiv.org/abs/2403.04893)\] <br />
Shayne Longpre,  Sayash Kapoor,  Kevin Klyman,  Ashwin Ramaswami,  Rishi Bommasani,  Borhane Blili-Hamelin,  Yangsibo Huang,  Aviya Skowron,  Zheng-Xin Yong,  Suhas Kotha,  Yi Zeng,  Weiyan Shi,  Xianjun Yang,  Reid Southen,  Alexander Robey,  Patrick Chao,  Diyi Yang,  Ruoxi Jia,  Daniel Kang,  Sandy Pentland,  Arvind Narayanan,  Percy Liang,  Peter Henderson (2024)<br />
- **The Ethics of Interaction: Mitigating Security Threats in LLMs** \[[Paper](https://arxiv.org/abs/2401.12273)\] <br />
Ashutosh Kumar,  Shiv Vignesh Murthy,  Sagarika Singh,  Swathy Ragupathy (2024)<br />
- **Red-Teaming for Generative AI: Silver Bullet or Security Theater?** \[[Paper](https://arxiv.org/abs/2401.15897)\] <br />
Michael Feffer,  Anusha Sinha,  Wesley Hanwen Deng,  Zachary C. Lipton,  Hoda Heidari (2024)<br />
- **The Promise and Peril of Artificial Intelligence -- Violet Teaming Offers a Balanced Path Forward** \[[Paper](https://arxiv.org/abs/2308.14253)\] <br />
Alexander J. Titus,  Adam H. Russell (2023)<br />
- **Red teaming ChatGPT via Jailbreaking: Bias,Robustness,Reliability and Toxicity** \[[Paper](https://arxiv.org/abs/2301.12867)\] <br />
Terry Yue Zhuo,  Yujin Huang,  Chunyang Chen,  Zhenchang Xing (2023)<br />
## Phenomenon
- **Red-Teaming Segment Anything Model** \[[Paper](https://arxiv.org/abs/2404.02067)\] <br />
Krzysztof Jankowski,  Bartlomiej Sobieski,  Mateusz Kwiatkowski,  Jakub Szulc,  Michal Janik,  Hubert Baniecki,  Przemyslaw Biecek (2024)<br />
- **How Ethical Should AI Be? How AI Alignment Shapes the Risk Preferences of LLMs** \[[Paper](https://arxiv.org/abs/2406.01168
   )\] <br />
Shumiao Ouyang,  Hayong Yun,  Xingjian Zheng (2024)<br />
- **Subtoxic Questions: Dive Into Attitude Change of LLM's Response in Jailbreak Attempts** \[[Paper](https://arxiv.org/abs/2404.08309
   )\] <br />
Tianyu Zhang,  Zixuan Zhao,  Jiaqi Huang,  Jingyu Hua,  Sheng Zhong (2024)<br />
- **Exploring Safety-Utility Trade-Offs in Personalized Language Models** \[[Paper](https://arxiv.org/abs/2406.11107
   )\] <br />
Anvesh Rao Vijjini,  Somnath Basu Roy Chowdhury,  Snigdha Chaturvedi (2024)<br />
- **AI Risk Management Should Incorporate Both Safety and Security** \[[Paper](https://arxiv.org/abs/2405.19524
   )\] <br />
Xiangyu Qi,  Yangsibo Huang,  Yi Zeng,  Edoardo Debenedetti,  Jonas Geiping,  Luxi He,  Kaixuan Huang,  Udari Madhushani,  Vikash Sehwag,  Weijia Shi,  Boyi Wei,  Tinghao Xie,  Danqi Chen,  Pin-Yu Chen,  Jeffrey Ding,  Ruoxi Jia,  Jiaqi Ma,  Arvind Narayanan,  Weijie J Su,  Mengdi Wang,  Chaowei Xiao,  Bo Li,  Dawn Song,  Peter Henderson,  Prateek Mittal (2024)<br />
- **Adversaries Can Misuse Combinations of Safe Models** \[[Paper](https://arxiv.org/abs/2406.14595
   )\] <br />
Erik Jones,  Anca Dragan,  Jacob Steinhardt (2024)<br />
- **Finding Safety Neurons in Large Language Models** \[[Paper](https://arxiv.org/abs/2406.14144
   )\] <br />
Jianhui Chen,  Xiaozhi Wang,  Zijun Yao,  Yushi Bai,  Lei Hou,  Juanzi Li (2024)<br />
- **Assessing the Brittleness of Safety Alignment via Pruning and Low-Rank Modifications** \[[Paper](https://arxiv.org/abs/2402.05162)\] <br />
Boyi Wei,  Kaixuan Huang,  Yangsibo Huang,  Tinghao Xie,  Xiangyu Qi,  Mengzhou Xia,  Prateek Mittal,  Mengdi Wang,  Peter Henderson (2024)<br />
- **Speak Out of Turn: Safety Vulnerability of Large Language Models in Multi-turn Dialogue** \[[Paper](https://arxiv.org/abs/2402.17262)\] <br />
Zhenhong Zhou,  Jiuyang Xiang,  Haopeng Chen,  Quan Liu,  Zherui Li,  Sen Su (2024)<br />
- **A Mechanistic Understanding of Alignment Algorithms: A Case Study on DPO and Toxicity** \[[Paper](https://arxiv.org/abs/2401.01967)\] <br />
Andrew Lee,  Xiaoyan Bai,  Itamar Pres,  Martin Wattenberg,  Jonathan K. Kummerfeld,  Rada Mihalcea (2024)<br />
- **Tradeoffs Between Alignment and Helpfulness in Language Models** \[[Paper](https://arxiv.org/abs/2401.16332)\] <br />
Yotam Wolf,  Noam Wies,  Dorin Shteyman,  Binyamin Rothberg,  Yoav Levine,  Amnon Shashua (2024)<br />
- **Causality Analysis for Evaluating the Security of Large Language Models** \[[Paper](https://arxiv.org/abs/2312.07876)\] <br />
Wei Zhao,  Zhe Li,  Jun Sun (2023)<br />
- **Fake Alignment: Are LLMs Really Aligned Well?** \[[Paper](https://arxiv.org/abs/2311.05915)\] <br />
Yixu Wang,  Yan Teng,  Kexin Huang,  Chengqi Lyu,  Songyang Zhang,  Wenwei Zhang,  Xingjun Ma,  Yu-Gang Jiang,  Yu Qiao,  Yingchun Wang (2023)<br />
- **Transfer Attacks and Defenses for Large Language Models on Coding Tasks** \[[Paper](https://arxiv.org/abs/2311.13445)\] <br />
Chi Zhang,  Zifan Wang,  Ravi Mangal,  Matt Fredrikson,  Limin Jia,  Corina Pasareanu (2023)<br />
- **"It's a Fair Game'',or Is It? Examining How Users Navigate Disclosure Risks and Benefits When Using LLM-Based Conversational Agents** \[[Paper](https://arxiv.org/abs/2309.11653)\] <br />
Zhiping Zhang,  Michelle Jia,  Hao-Ping Lee,  Bingsheng Yao,  Sauvik Das,  Ada Lerner,  Dakuo Wang,  Tianshi Li (2023)<br />
- **Are aligned neural networks adversarially aligned?** \[[Paper](https://arxiv.org/abs/2306.15447)\] <br />
Nicholas Carlini,  Milad Nasr,  Christopher A. Choquette-Choo,  Matthew Jagielski,  Irena Gao,  Anas Awadalla,  Pang Wei Koh,  Daphne Ippolito,  Katherine Lee,  Florian Tramer,  Ludwig Schmidt (2023)<br />
- **Exploiting Programmatic Behavior of LLMs: Dual-Use Through Standard Security Attacks** \[[Paper](https://arxiv.org/abs/2302.05733)\] <br />
Daniel Kang,  Xuechen Li,  Ion Stoica,  Carlos Guestrin,  Matei Zaharia,  Tatsunori Hashimoto (2023)<br />
- **Can Large Language Models Change User Preference Adversarially?** \[[Paper](https://arxiv.org/abs/2302.10291)\] <br />
Varshini Subhash (2023)<br />
### Mechanistic Interpretability
- **Towards Understanding Jailbreak Attacks in LLMs: A Representation Space Analysis** \[[Paper](https://arxiv.org/abs/2406.10794
   )\] <br />
Yuping Lin,  Pengfei He,  Han Xu,  Yue Xing,  Makoto Yamada,  Hui Liu,  Jiliang Tang (2024)<br />
- **How Alignment and Jailbreak Work: Explain LLM Safety through Intermediate Hidden States** \[[Paper](https://arxiv.org/abs/2406.05644
   )\] <br />
Zhenhong Zhou,  Haiyang Yu,  Xinghua Zhang,  Rongwu Xu,  Fei Huang,  Yongbin Li (2024)<br />
- **Understanding Jailbreak Success: A Study of Latent Space Dynamics in Large Language Models** \[[Paper](https://arxiv.org/abs/2406.09289
   )\] <br />
Sarah Ball,  Frauke Kreuter,  Nina Rimsky (2024)<br />
- **Safety Alignment Should Be Made More Than Just a Few Tokens Deep** \[[Paper](https://arxiv.org/abs/2406.05946
   )\] <br />
Xiangyu Qi,  Ashwinee Panda,  Kaifeng Lyu,  Xiao Ma,  Subhrajit Roy,  Ahmad Beirami,  Prateek Mittal,  Peter Henderson (2024)<br />